/*-----------------------------------------------------------------------------
   File: DDEx1.CPP

   Desc: Direct Draw example program 1.  Creates a Direct Draw 
         object and then a primary surface with a back buffer.
         The Program then creates a 3D object and rotates it while 
  		 performing the following -

			Z-Buffering
			Texture Mapping (Very Basic, and slow!!) 

		 Please note the code used to create this is based on parts 
		 from the following microsoft Direct Draw examples -
	
			DDEx1
			Flip2D
		
		 All the 3D code was written by me and the render code was 
		 significantly modified from "Flip2D" to provide the features 
		 The Fixed point data type was also taken from "Flip2D". All 
		 Windows initialisation code was taken from "DDEx1".

		 This is a re write of an earlier piece of code I wrote.  It 
		 has been modified to make use of Direct Input so that now the 
		 "World" can be walked around.  The default keys are -

								A - Forward
			LSHIFT - Step Left					X - Step Right
								Z - Backward
			
			To look around use the mouse.

		 The Code was also reorganised to remove the need for as many 
		 Global Variables.  The only globals are now the variable to 
		 check that the program is still active and the pointer to the
		 class the Graphics Code was moved into.  All Constants are also 
		 kept globally to allow a user to change things a little more easily.

			Oscar Forth 10 July 1999
  -----------------------------------------------------------------------------*/

/*#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif*/

#ifndef STRICT
#define STRICT
#endif

//-----------------------------------------------------------------------------
// Include files
//-----------------------------------------------------------------------------

#include "includes.h" // Contains all constant expressions.
#include "TDDraw.h"

BOOL	g_bActive = FALSE;   // Is application active?

TDDraw  *td;

static void UpdateFrame(TDDraw *td, TWorld *World)
{
	
	// Increment then x, y and z angles.
	
	td->Render(World);
}	
//-----------------------------------------------------------------------------
// Name: WindowProc()
// Desc: The Main Window Procedure
//-----------------------------------------------------------------------------
long FAR PASCAL WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    HRESULT                     hRet;

    switch (message)
    {
        case WM_ACTIVATEAPP:
            g_bActive = (wParam == WA_ACTIVE) || (wParam == WA_CLICKACTIVE);
			return 0L;

        case WM_DESTROY:
			delete td;
            PostQuitMessage(0);
            return 0L;

        case WM_KEYDOWN:
            switch (wParam)
            {
                case VK_ESCAPE:
                    PostMessage(hWnd, WM_DESTROY, 0, 0);
                    return 0L;
				
            }
            break;
	
		case WM_SETCURSOR:
            SetCursor(NULL);
            return TRUE;

    }
		    
		    
    return DefWindowProc(hWnd, message, wParam, lParam);
}
BOOL CALLBACK FOVDialogProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    HRESULT                     hRet;

    if( WM_COMMAND == uMsg )
		if( ID_OK == LOWORD(wParam) || ID_Cancel == LOWORD(wParam) )
			EndDialog (hWnd, 500);

    return ( WM_INITDIALOG == uMsg ) ? TRUE : FALSE;
	return false;
}

void Move(TCamera *Camera, int direction)
{
	int x = Camera->GetXPosition();
	int y = Camera->GetYPosition();
	int z = Camera->GetZPosition();

	int Yaw = Camera->GetYaw();
	int Pitch = Camera->GetPitch();
	int Roll = Camera->GetPitch();
	if (direction == Left || direction == Right) 
	{
		Yaw += 64;
		direction /= Left;
	}
	if (direction == Up || direction == Down) 
	{
		Pitch -= 64;
		direction /= Up;
	}
	TMaths *tm;
	tm = new TMaths();
	
	float sxa = tm->Sine(Pitch);
	float cxa = tm->CoSine(Pitch);
	
	float sya = tm->Sine(-Yaw);
	float cya = tm->CoSine(-Yaw);

	delete tm;

	float x1 = sya;
	float y1 = 1;
	float z1 = cya;

	float x2 = x1;
	float y2 = y1 * sxa;
	float z2 = z1 * cxa;

	x += direction * 10 * x2;
	y += direction * 10 * y2;
	z += direction * 10 * z2;
	
	Camera->SetXPosition(x);
	Camera->SetYPosition(y);
	Camera->SetZPosition(z);
}

//-----------------------------------------------------------------------------
// Name: WinMain()
// Desc: Initialization, message loop
//-----------------------------------------------------------------------------
int WINAPI
WinMain(HINSTANCE hInstance,
        HINSTANCE hPrevInstance,
        LPSTR lpCmdLine,
        int nCmdShow)
{
	// Initialise the Polgon Vertex details
	T3dVertex *Vertices[5];

	Vertices[0] = new T3dVertex(   0, 100,   0,OzRGB(255,  0,  0),   0,  50);
	Vertices[1] = new T3dVertex(   0,-100, 100,OzRGB(  0,255,  0),  50, -50);
	Vertices[2] = new T3dVertex(   0,-100,-100,OzRGB(  0,  0,255), -50, -50);
	Vertices[3] = new T3dVertex(-100,-100,   0,OzRGB(  0,255,  0), -50, -50);
	Vertices[4] = new T3dVertex(100 ,-100,   0,OzRGB(  0,  0,255),  50, -50);
	
	
	// Initialise the Polgon Edge details
	
	TEdge *Edges[12];

	Edges[0] = new TEdge(Vertices[0],Vertices[2]);
	Edges[1] = new TEdge(Vertices[2],Vertices[1]);
	Edges[2] = new TEdge(Vertices[1],Vertices[0]);
	
	Edges[3] = new TEdge(Vertices[0],Vertices[1]);
	Edges[4] = new TEdge(Vertices[1],Vertices[2]);
	Edges[5] = new TEdge(Vertices[2],Vertices[0]);

	Edges[6] = new TEdge(Vertices[0],Vertices[3]);
	Edges[7] = new TEdge(Vertices[3],Vertices[4]);
	Edges[8] = new TEdge(Vertices[4],Vertices[0]);
	
	Edges[9] = new TEdge(Vertices[0],Vertices[4]);
	Edges[10] = new TEdge(Vertices[4],Vertices[3]);
	Edges[11] = new TEdge(Vertices[3],Vertices[0]);
	
	// Initialise the Polgon Face details
	
	TFace *Faces[4];
	
	Faces[0] = new TFace( Edges[0], Edges[1], Edges[2],OzRGB(255,255,0),Texture1, Tex1X, Tex1Y);
	Faces[1] = new TFace( Edges[3], Edges[4], Edges[5],OzRGB(192,192,0),Texture1, Tex1X, Tex1Y);
	Faces[2] = new TFace( Edges[6], Edges[7], Edges[8],OzRGB(128,128,0),Texture4, Tex4X, Tex4Y);
	Faces[3] = new TFace( Edges[9],Edges[10],Edges[11],OzRGB(64,64,0),Texture4, Tex4X, Tex4Y);
	
	T3dVertex *Vertices2[4];

	Vertices2[0] = new T3dVertex( 300,   0, 300,OzRGB(0,255,0), 300, 300);
	Vertices2[1] = new T3dVertex( 300,   0,-300,OzRGB(0,192,0),-300, 300);
	Vertices2[2] = new T3dVertex(-300,   0,-300,OzRGB(0,128,0),-300,-300);
	Vertices2[3] = new T3dVertex(-300,   0, 300,OzRGB(0,64,0), 300,-300);
	
	
	
	// Initialise the Polgon Edge details
	
	TEdge *Edges2[6];

	Edges2[0] = new TEdge(Vertices2[0],Vertices2[1]);
	Edges2[1] = new TEdge(Vertices2[1],Vertices2[2]);
	Edges2[2] = new TEdge(Vertices2[2],Vertices2[0]);
	
	Edges2[3] = new TEdge(Vertices2[0],Vertices2[2]);
	Edges2[4] = new TEdge(Vertices2[2],Vertices2[3]);
	Edges2[5] = new TEdge(Vertices2[3],Vertices2[0]);

	// Initialise the Polgon Face details
	
	TFace *Faces2[2];
	
	Faces2[0] = new TFace( Edges2[0], Edges2[1], Edges2[2],OzRGB(0,255,0),Texture3, Tex3X, Tex3Y);
	Faces2[1] = new TFace( Edges2[3], Edges2[4], Edges2[5],OzRGB(0,192,0),Texture3, Tex3X, Tex3Y);
	
	TObject *Objects[14];
	
	Objects[0] = new TObject(Faces ,4, 100,-100,   0);
	Objects[1] = new TObject(Faces ,4,-100,-100,   0);
	Objects[2] = new TObject(Faces ,4,   0,-100, 100);
	Objects[3] = new TObject(Faces ,4,   0,-100,-100);
	Objects[4] = new TObject(Faces ,4,   0, 100,   0);
	Objects[5] = new TObject(Faces2,2,   0,-200,   0);
	Objects[6] = new TObject(Faces2,2,   0,-200, 600);
	Objects[7] = new TObject(Faces2,2,   0,-200,-600);
	Objects[8] = new TObject(Faces2,2, 600,-200,   0);
	Objects[9] = new TObject(Faces2,2,-600,-200,   0);
	Objects[10] = new TObject(Faces2,2,-600,-200,-600);
	Objects[11] = new TObject(Faces2,2,-600,-200, 600);
	Objects[12] = new TObject(Faces2,2, 600,-200, 600);
	Objects[13] = new TObject(Faces2,2, 600,-200,-600);
	
	TCamera *Camera;
	int zpos = -1500;
	Camera = new TCamera(0,0,zpos,0,0,0,prp);

	TWorld *World;

	World = new TWorld(Objects,14,Camera);

	MSG                         msg;


	td = new TDDraw;

	//if (td->TDDrawInit(hInstance, nCmdShow, 200,824,200,568,1024, 768, 8,"OzDD", "Oz's Direct Draw Program") != DD_OK) return false;
	if (td->TDDrawInit(hInstance, nCmdShow, 0,ScreenX,0,ScreenY,ScreenX, ScreenY, Screenbpp,"OzDD", "Oz's Direct Draw Program") != DD_OK) return false;
	
	LPDIRECTINPUT  DInput; 
	LPDIRECTINPUTDEVICE KeyBoard;
	LPDIRECTINPUTDEVICE Mouse;

	if (DirectInputCreate(hInstance, DIRECTINPUT_VERSION, &DInput, NULL) != DD_OK) exit(1); 
	if (DInput->CreateDevice(GUID_SysKeyboard, &KeyBoard, NULL) != DD_OK) 
	{ 
		return FALSE; 
	} 
	if (DInput->CreateDevice(GUID_SysMouse, &Mouse, NULL) != DD_OK) 
	{ 
		return FALSE; 
	} 
	if (KeyBoard->SetDataFormat(&c_dfDIKeyboard) != DD_OK) 
 	{ 
		return FALSE; 
	} 
	if (Mouse->SetDataFormat(&c_dfDIMouse) != DD_OK) 
 	{ 
		return FALSE; 
	} 
	if (KeyBoard->SetCooperativeLevel(td->GetWindowHandle(),DISCL_FOREGROUND | DISCL_NONEXCLUSIVE) != DD_OK) 
	{ 
		return FALSE; 
	} 
	if (Mouse->SetCooperativeLevel(td->GetWindowHandle(),DISCL_FOREGROUND | DISCL_NONEXCLUSIVE) != DD_OK) 
	{ 
		return FALSE; 
	} 
	
	if (KeyBoard) KeyBoard->Acquire(); 
	if (Mouse) Mouse->Acquire(); 

	float xang = 0.0f;
	float yang = 0.0f;
	float zang = 0.0f;

	td->SetRenderType(DDZBuffer + DDGouraud);
	td->SetFogColour(0, 0, 32);
	while (TRUE)
    {
        if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
        {
            if (!GetMessage(&msg, NULL, 0, 0))
                return msg.wParam;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }

		// Run the program essentially.

        else if (g_bActive)
            {
				char     buffer[256]; 

				DIMOUSESTATE MouseState;

				HRESULT  hr; 

				hr = KeyBoard->GetDeviceState(sizeof(buffer),(LPVOID)&buffer); 
				if FAILED(hr) 
				{ 
					break; 
				} 
				hr = Mouse->GetDeviceState(sizeof(MouseState),(LPVOID)&MouseState); 
				if FAILED(hr) 
				{ 
					break; 
				} 
				
				World->GetCamera()->SetYaw(yang -= ((float)MouseState.lX / 4.0f) ); 
				World->GetCamera()->SetPitch(xang -= ((float)MouseState.lY / 4.0f) ); 

				if (buffer[MoveForward] & 0x80)
				{	
					Move(World->GetCamera(),Forward);
				} else if (buffer[MoveBack] & 0x80) 
				{
					Move(World->GetCamera(),Back);
				}

				if (buffer[MoveLeft] & 0x80)
				{
					Move(World->GetCamera(),Left);
				} else if (buffer[MoveRight] & 0x80)
				{
					Move(World->GetCamera(),Right);
				}
				
				if (buffer[MoveUp] & 0x80)
				{
					Move(World->GetCamera(),Up);
				} else if (buffer[MoveDown] & 0x80)
				{
					Move(World->GetCamera(),Down);
				}
				if (buffer[DIK_TAB] & 0x80)
				{
				//	g_bActive = false;
					int bpp = Screenbpp;
					
					if (bpp == 8)  bpp = 16;
					else if (bpp == 16) bpp = 24;
					else if (bpp == 24) bpp = 32;
					else if (bpp == 32) bpp = 8;

					Screenbpp = bpp;
					
					td->NewResolution(ScreenX, ScreenY, bpp);
					
					if (DInput) DInput->Release(), DInput = NULL;
					if (KeyBoard) KeyBoard->Release(), KeyBoard = NULL;
					if (Mouse) Mouse->Release(), Mouse = NULL;
					
					if (DInput) DInput->Release(), DInput = NULL;
					if (DirectInputCreate(hInstance, DIRECTINPUT_VERSION, &DInput, NULL) != DD_OK) exit(1); 
					if (DInput->CreateDevice(GUID_SysKeyboard, &KeyBoard, NULL) != DD_OK) 
					{ 
						return FALSE; 
					} 
					if (DInput->CreateDevice(GUID_SysMouse, &Mouse, NULL) != DD_OK) 
					{ 
						return FALSE; 
					} 
					if (KeyBoard->SetDataFormat(&c_dfDIKeyboard) != DD_OK) 
 					{ 
						return FALSE; 
					} 
					if (Mouse->SetDataFormat(&c_dfDIMouse) != DD_OK) 
 					{ 
						return FALSE; 
					} 
					if (KeyBoard->SetCooperativeLevel(td->GetWindowHandle(),DISCL_FOREGROUND | DISCL_NONEXCLUSIVE) != DD_OK) 
					{ 
						return FALSE; 
					} 
					if (Mouse->SetCooperativeLevel(td->GetWindowHandle(),DISCL_FOREGROUND | DISCL_NONEXCLUSIVE) != DD_OK) 
					{ 
						return FALSE; 
					} 
					
					if (KeyBoard) KeyBoard->Acquire(); 
					if (Mouse) Mouse->Acquire(); 

				
				} 
	
				if (buffer[ZoomIn] & 0x80)
				{
					int temp = World->GetCamera()->GetFOV();
					temp += 10;
					World->GetCamera()->SetFOV(temp);
				}
				else if (buffer[ZoomOut] & 0x80)
				{
					int temp = World->GetCamera()->GetFOV();
					temp -= 10;
					World->GetCamera()->SetFOV(temp);
				}

                UpdateFrame(td, World);
                while (TRUE)
                {
                    if (td->Flip(NULL, 0)) break;
					
                }
            }
        else
        {
            WaitMessage();
        }
    }
	
}
