
#define M_PI 3.1415

const TopClip    = 1;
const BottomClip = 2;
const RightClip  = 4;
const LeftClip   = 8;


class TMaths {
	public:
		float Sine(float s)
		{
		/*	if ((s >= 0 ) && (s <= 255)) return sin(s*(M_PI/128));
			return 0;*/
			return sin(s*(M_PI/128.0f));
		}

		float CoSine(float c)
		{
		
			/*if ((c >= 0 ) && (c <= 255)) return cos(c*(M_PI/128));
			return 0;*/
			return cos(c*(M_PI/128.0f));
		}
		float Tangent(float t)
		{
			//if (t == 64) return ;
			return Sine(t) / CoSine(t);
		}
};

class TVertex {
	private:
   		int x,y;
	public:
		virtual int GetX() = 0;
		virtual int GetY() = 0;

		virtual void SetX(int)  = 0;
		virtual void SetY(int) = 0;
};
class T2dVertex : TVertex {
	private:
   		int x,y;
	public:
		T2dVertex() {}
		T2dVertex(int xx, int yy)
		{
      		x = xx;
			y = yy;
		}

		int GetX() { return x;}
		int GetY() { return y;}

		void SetX(int xx) { x = xx; }
		void SetY(int yy) { y = yy; }
};

class T3dVertex : TVertex {
	private:
   		int x,y,z,s,t;
   		T2dVertex *ViewVertex;
		T3dVertex *WorldVertex;
		static int dist;
		static int prp;
		static int exaggerate;
		DWORD Colour;
		BYTE Red;
		BYTE Green;
		BYTE Blue;
		bool visited;
	public:
   		T3dVertex(int xx, int yy, int zz, DWORD colour, int ss=0, int tt=0)
		{
			x = xx;
			y = yy;
			z = zz;
			Colour = colour;
			s = ss;
			t = tt;
			visited = false;

			Red = ((BYTE) ((colour) >> 16)); 
			Green = ((BYTE) (((WORD) (colour)) >> 8));
			Blue = ((BYTE) (colour));
		}

		int GetX() { return x;}
		int GetY() { return y;}
		int GetZ() { return z;}
		int GetS() { return s;}
		int GetT() { return t;}

		DWORD GetColour() { return Colour; }
		BYTE GetRed()     { return Red;    }
		BYTE GetGreen()   { return Green;  }
		BYTE GetBlue()    { return Blue;   }
		
		void SetX(int xx) { x = xx; }
		void SetY(int yy) { y = yy; }
		void SetZ(int zz) { z = zz; }
		void SetS(int ss) { s = ss; }
		void SetT(int tt) { t = tt; }
		void SetColour(DWORD colour) { Colour = colour; }

		T2dVertex *GetVertex() { return ViewVertex; }
		T3dVertex *GetWorldVertex() { return WorldVertex; }
		
		void Convertto2d(float xang, float yang, float zang,int dist=100,int prp=500, int exaggerate=1, int pointofxr = 0, int pointofyr = 0, int pointofzr = 0, int MinZ = 200, int MaxZ = 4096)
		{
			if (!visited) 
			{
				TMaths *tm;
				tm = new TMaths;

				float sxa = tm->Sine(xang);
				float sya = tm->Sine(yang);
				float sza = tm->Sine(zang);

				float cxa = tm->CoSine(xang);
				float cya = tm->CoSine(yang);
				float cza = tm->CoSine(zang);

				int x = this->x + pointofxr;
				int y = this->y + pointofyr;
				int z = this->z + pointofzr;

				/*float x1 = (x * cza) - (y * sza);
				float y1 = (x * sza) + (y * cza);
				float z1 = z;

				float x2 = x1;
				float y2 = (y1 * cxa) - (z1 * sxa);
				float z2 = (y1 * sxa) + (z1 * cxa);

				x1 = (z2 * sya) + (x2 * cya);
				y1 = y2;
				z1 = (z2 * cya) - (x2 * sya);*/

				float x1 = (z * sya) + (x * cya);
				float y1 = y;
				float z1 = (z * cya) - (x * sya);
				
				float x2 = x1;
				float y2 = (y1 * cxa) - (z1 * sxa);
				float z2 = (y1 * sxa) + (z1 * cxa);
				
				x1 = (x2 * cza) - (y2 * sza);
				y1 = (x2 * sza) + (y2 * cza);
				z1 = z2;

				z1 = z1 * exaggerate;
				
				
				z1 = z1 - dist;
				
				if (z1 > -MinZ) z1 = -MinZ + 1;
				//if (z1 < -MaxZ) z1 = -MaxZ - 1;

				x2 = prp * (x1 / z1);
				y2 = prp * (y1 / z1);
				
				int x3,y3;
				
				if (x2 > 32767) x3 = 32767;
				else if (x2 < -32768) x3 = -32768;
				else x3 = (int)x2;

				if (y2 > 32767) y3 = 32767;
				else if (y2 < -32768) y3 = -32768;
				else y3 = (int)y2;

				WorldVertex = new T3dVertex((int)x1,(int)y1,(int)z1,this->Colour,this->s, this->t);
				
				ViewVertex = new T2dVertex(x3,y3);		
				delete tm;
				visited = true;
			}
		};
	
		void Calculations_Finished()
		{
			visited = false;
		}
};
class TEdge {
	private:
   		T3dVertex *From;
		T3dVertex *To;

	public:
   		TEdge(T3dVertex *from, T3dVertex *to)
		{
  			From = from;
        	To = to;

		}

		T3dVertex *GetFromVertex() { return From; }
		T3dVertex *GetToVertex() { return To; }

		T2dVertex *GetFrom2dVertex() { return From->GetVertex(); }
		T2dVertex *GetTo2dVertex() { return To->GetVertex(); }

		T3dVertex *GetFrom3dVertex() { return From->GetWorldVertex(); }
		T3dVertex *GetTo3dVertex() { return To->GetWorldVertex(); }


//      int GetGradient() { return Gradient; }
		void SetFromVertex(T3dVertex *from) { From = from; }
		void SetToVertex(T3dVertex *to) { To = to; }
};
class TFace {
	private:
   		TEdge *One, *Two, *Three;
		int TexX, TexY;
		DWORD *Texture;
   		DWORD Colour;
	public:
   		TFace(TEdge *one, TEdge *two, TEdge *three, DWORD colour, DWORD *texture = NULL, int texX = 1, int texY = 1)
		{
      		One = one;
			Two = two;
			Three = three;
			Colour = colour;
			if (texture == NULL) Texture = new DWORD[1];
			else Texture = texture;

			TexX = texX;
			TexY = texY;
		}
		TFace(){}

   		TEdge *GetEdge1() { return One; }
		TEdge *GetEdge2() { return Two; }
		TEdge *GetEdge3() { return Three; }

		DWORD *GetTexture() { return Texture; }
		int GetTexX() { return TexX; }
		int GetTexY() { return TexY; }

		TEdge *GetEdge(int index)
		{
			
			if (index == 0) return One;
			if (index == 1) return Two;
			if (index == 2) return Three;
			return NULL;
		}

		DWORD GetColour() { return Colour;}

		void SetEdge1(TEdge *one) { One = one; }
		void SetEdge2(TEdge *two) { Two = two; }
		void SetEdge3(TEdge *three) { Three = Three; }
		
		
		bool Visible(int MinClipX = 0, int MaxClipX = 0, int MinClipY = 640, int MaxClipY = 480, int xo = 320, int yo = 240)
		{
			
			int ax = One->GetFrom2dVertex()->GetX() - Two->GetFrom2dVertex()->GetX();
			int ay = One->GetFrom2dVertex()->GetY() - Two->GetFrom2dVertex()->GetY();
			int bx = Three->GetFrom2dVertex()->GetX() - Two->GetFrom2dVertex()->GetX();
			int by = Three->GetFrom2dVertex()->GetY() - Two->GetFrom2dVertex()->GetY();

			int resvec = ax * by - ay * bx;
			if (resvec > 0) return false;
			else 
			{
				int clipregions = 0;
				
				ax = One->GetFrom2dVertex()->GetX();
				ay = One->GetFrom2dVertex()->GetY();
				
				int MinX = ax, MaxX = ax, MinY = ay, MaxY = ay;
				
				//Get Minimum and Maximum X Co-ordinates.
				
				if (One->GetTo2dVertex()->GetX()     < MinX) MinX = One->GetTo2dVertex()->GetX();
				if (One->GetTo2dVertex()->GetX()     > MaxX) MaxX = One->GetTo2dVertex()->GetX();

				if (Two->GetFrom2dVertex()->GetX()   < MinX) MinX = Two->GetFrom2dVertex()->GetX();
				if (Two->GetFrom2dVertex()->GetX()   > MaxX) MaxX = Two->GetFrom2dVertex()->GetX();
				
				if (Two->GetTo2dVertex()->GetX()     < MinX) MinX = Two->GetTo2dVertex()->GetX();
				if (Two->GetTo2dVertex()->GetX()     > MaxX) MaxX = Two->GetTo2dVertex()->GetX();
				
				if (Three->GetFrom2dVertex()->GetX() < MinX) MinX = Three->GetFrom2dVertex()->GetX();
				if (Three->GetFrom2dVertex()->GetX() > MaxX) MaxX = Three->GetFrom2dVertex()->GetX();
				
				if (Three->GetTo2dVertex()->GetX()   < MinX) MinX = Three->GetTo2dVertex()->GetX();
				if (Three->GetTo2dVertex()->GetX()   > MaxX) MaxX = Three->GetTo2dVertex()->GetX();
				
				//Get Minimum and Maximum Y Co-ordinates.

				if (One->GetTo2dVertex()->GetY()     < MinY) MinY = One->GetTo2dVertex()->GetY();
				if (One->GetTo2dVertex()->GetY()     > MaxY) MaxY = One->GetTo2dVertex()->GetY();
				
				if (Two->GetFrom2dVertex()->GetY()   < MinY) MinY = Two->GetFrom2dVertex()->GetY();
				if (Two->GetFrom2dVertex()->GetY()   > MaxY) MaxY = Two->GetFrom2dVertex()->GetY();
				
				if (Two->GetTo2dVertex()->GetY()     < MinY) MinY = Two->GetTo2dVertex()->GetY();
				if (Two->GetTo2dVertex()->GetY()     > MaxY) MaxY = Two->GetTo2dVertex()->GetY();
				
				if (Three->GetFrom2dVertex()->GetY() < MinY) MinY = Three->GetFrom2dVertex()->GetY();
				if (Three->GetFrom2dVertex()->GetY() > MaxY) MaxY = Three->GetFrom2dVertex()->GetY();
				
				if (Three->GetTo2dVertex()->GetY()   < MinY) MinY = Three->GetTo2dVertex()->GetY();
				if (Three->GetTo2dVertex()->GetY()   > MaxY) MaxY = Three->GetTo2dVertex()->GetY();
				
				MinX += xo;
				MaxX += xo;

				MinY += yo;
				MaxY += yo;

				if      (MinX < MinClipX && MaxX < MinClipX) clipregions = clipregions + LeftClip;
				else if (MinX > MaxClipX && MaxX > MaxClipX) clipregions = clipregions + RightClip;
				
				if      (MinY < MinClipY && MaxY < MinClipY) clipregions = clipregions + TopClip;
				else if (MinY > MaxClipY && MaxY > MaxClipY) clipregions = clipregions + BottomClip;


				if (clipregions & TopClip) return false;
				else if (clipregions & BottomClip) return false;
				else if (clipregions & RightClip) return false;
				else if (clipregions & LeftClip) return false;
				else return true;
			}
		};
};

class TObject
{
	private:
		TFace **ObjectFaces;
		int WorldX;
		int WorldY;
		int WorldZ;
		bool Clipped;
		int NumFaces;
	public:
		TObject(TFace *objectFaces[], int numfaces, int worldx = 0, int worldy = 0, int worldz = 0)
		{
			ObjectFaces = (new TFace*[numfaces]);
			ObjectFaces = objectFaces;
			NumFaces = numfaces;
			WorldX = worldx;
			WorldY = worldy;
			WorldZ = worldz;
			Clipped = false;
		}
		
		int GetFaceNum() { return NumFaces; }
		TFace *GetFace(int index) { return ObjectFaces[index]; }
		
		int GetWorldX()				{ return WorldX; }
		int GetWorldY()				{ return WorldY; }
		int GetWorldZ()				{ return WorldZ; }
		bool GetClipped()			{ return Clipped;}

		void SetWorldX(int x)		{ WorldX = x;    }
		void SetWorldY(int y)		{ WorldY = y;    }
		void SetWorldZ(int z)		{ WorldZ = z;    }
		void SetClipped(bool clip)  { Clipped = clip; }



};

class TCamera
{
	private:
		int FOV;
		int xPos;
		int yPos;
		int zPos;
		float Pitch;
		float Yaw;
		float Roll;
		
		
	public:
		TCamera(int xpos, int ypos, int zpos, float pitch, float yaw, float roll, int fov = 500)
		{
			xPos  = xpos;
			yPos  = ypos;
			zPos  = zpos;
			Pitch = pitch;
			Yaw   = yaw;
			Roll  = roll;
			FOV   = fov;
		}
		
		void SetXPosition(int xpos) { xPos = xpos;   }
		void SetYPosition(int ypos) { yPos = ypos;   }
		void SetZPosition(int zpos) { zPos = zpos;   }

		void SetPitch(float pitch)  { Pitch = pitch; } 
		void SetYaw(float yaw)	    { Yaw = yaw;     } 
		void SetRoll(float roll)    { Roll = roll;   } 

		void SetFOV(int fov)		
		{
			if      (fov < 50) fov = 50;
			else if (fov > 6000) fov = 6000;

			FOV = fov;
		}

		int GetXPosition()			{ return xPos;   }
		int GetYPosition()			{ return yPos;   }
		int GetZPosition()			{ return zPos;   }

		float GetPitch()			{ return Pitch;  } 
		float GetYaw()				{ return Yaw;    } 
		float GetRoll()				{ return Roll;   } 
		
		int GetRawFOV()				
		{ 
			
			return FOV;
			
		}

		int GetFOV()				
		{ 
			
			return FOV;
		}

};
		
class TWorld
{
	private:
		TObject **WorldObjects;
		int NumObjects;
		TCamera *Camera;
		int ZRenderDepth;
	public:
		TWorld (TObject *objects[], int numobjects, TCamera *camera, int ZDepth = 4096) 
		{ 
			WorldObjects = (new TObject*[numobjects]);
			WorldObjects = objects;
			NumObjects   = numobjects;
			Camera = camera;
			ZRenderDepth = ZDepth;
		}
		
		int GetNumObjects() { return NumObjects; }

		TObject *GetObject(int index) { return WorldObjects[index]; }
		TCamera *GetCamera() { return Camera; }
		void CliptoCamera() {}
};