#include "includes.h"

class TDDraw {
	private:
		__int16 ScreenX;
		__int16 ScreenY;
		__int8 Bpp;
		__int16 xo;
		__int16 yo;
		__int32 ScreenSize;

		__int16 MaxClipX;
		__int16 MinClipX;

		__int16 MaxClipY;
		__int16 MinClipY;
	
		__int16 ZMin;
		__int16 ZRenderDepth;
	
		PALETTEENTRY ape[256];

		LPDIRECTDRAW4               g_pDD;   
		LPDIRECTDRAWSURFACE4        Primary;	
		LPDIRECTDRAWSURFACE4        Back;	
		IDirectDrawPalette			*Palette;		
		DDSURFACEDESC2				ddsd;
		HWND                        hWnd;
		DDPIXELFORMAT				pf;		
		
		BYTE rshift;
		BYTE gshift;
		BYTE bshift;
		unsigned __int16 *ZBuffer;

		bool ZBuf;
		bool Gouraud;
		bool Texture;
		bool Fog;
		bool ZInit;
		bool perspective;	
		
		int Fogr;
		int Fogg;
		int Fogb;

		BYTE GetRGB(int r, int g, int b)
		{
			BYTE col = 0;

			r /= (256 / 5);
			g /= (256 / 5);
			b /= (256 / 5);
		
			col = b + (((g) * 6)) + (((r) * 36));
			
			return col + 10;
		}
		
		BYTE GetRed(DWORD colour)
		{
			return ((BYTE) ((colour) >> 16)); 
		}
		BYTE GetGreen(DWORD colour)
		{
			return ((BYTE) (((WORD) (colour)) >> 8));
		}
		BYTE GetBlue(DWORD colour)
		{
			return ((BYTE) (colour));
		}
		WORD GetNumberofBits( DWORD dwMask )
		{
			WORD wBits = 0;
			while( dwMask )
			{
				dwMask = dwMask & ( dwMask - 1 );  
				wBits++;
			}
			return wBits;
		}

		BYTE GetRGB8(DWORD colour)
		{
			
			
			BYTE r = GetRed(colour);
			BYTE g = GetGreen(colour);
			BYTE b = GetBlue(colour);
		
			r /= 32;
			g /= 64;
			b /= 32;
			
			BYTE col = b + (((g) << 3)) + (((r) << 5));
			
			return col;
		}

		DWORD GetRGB1624(DWORD colour)
		{
			BYTE r = GetRed(colour);
			BYTE g = GetGreen(colour);
			BYTE b = GetBlue(colour);
			
			r = r >> (8 - rshift);
			g = g >> (8 - gshift);
			b = b >> (8 - bshift);
			
			DWORD col = b + (((g) << bshift)) + (((r) << (bshift + gshift)));			
			
			return col;
		}
		
		void InitZBuffer()
		{
			if (!this->ZInit)
			{
				this->ZBuffer = new unsigned __int16[ScreenSize];
				this->ZInit = true;
			}
		}
		
		void ClearZBuffer(int BackValue = 65535)
		{
			int loop =0;
			do {
				this->ZBuffer[loop] = BackValue; 
				loop++;
			} while(loop<ScreenSize);
		}

		void ClearBackBuffer(DWORD colour = 0)
		{
			DDBLTFX		ddbltfx;  
					    
			ddbltfx.dwSize = sizeof(ddbltfx);

			if (Bpp == 1) 
			{
				ddbltfx.dwFillColor = GetRGB8(colour);
			
			} else if (Bpp == 2) 
			{
				
				ddbltfx.dwFillColor = GetRGB1624(colour);
			
			} else if (Bpp == 3)
			{
				ddbltfx.dwFillColor = GetRGB1624(colour);
			
			} else if (Bpp == 4)
			{

				ddbltfx.dwFillColor = colour;
			
			}
			//ddbltfx.dwFillColor = Colour;

			Back->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx);
		}
		/*********************************************************************************
		 *																				 *
		 *	The next two Procedures draw a filled polygon from the face colour details.	 *
		 *  It iteratively follows down each edge of the polygon and draws a line		 *
		 *	between the two points in the face colour.	OzTriangle8 makes extensive use	 *
		 *  of the Fixed point data type defined in "Flip2D".							 *
		 *																				 *
		 *********************************************************************************/

		void HLine(BYTE *p, int x0, int y, int x1,DWORD colour)
		{
			int loop = 0;
			p += ((x0)+(ScreenX * y));

			do {
				
				*((DWORD*)p) = colour;
				loop++;
				p ++ ;
			} while (loop < (x1-x0));
		}
		void OzTriangle8(BYTE *p, TFace *Face)
		{
   				
				{	
					int x1,y1,x2,y2,x3,y3;			
				{
					
					// Read in the Vertex details from the Face structure.
					
					T2dVertex *edge1f, *edge1t,*edge2f, *edge2t,*edge3f, *edge3t;
					{
						
						edge1f = Face->GetEdge1()->GetFrom2dVertex();
						edge1t = Face->GetEdge1()->GetTo2dVertex();
						
						edge2f = Face->GetEdge2()->GetFrom2dVertex();
						edge2t = Face->GetEdge2()->GetTo2dVertex();
						
			 			edge3f = Face->GetEdge3()->GetFrom2dVertex();
						edge3t = Face->GetEdge3()->GetTo2dVertex();
         				
					}
   					x1 = edge1f->GetX();
					y1 = edge1f->GetY();


					x2 = edge2f->GetX();
					y2 = edge2f->GetY();

					
					if (x2 == x1 && y2 == y1)
   					{
   						x2 = edge2t->GetX();
		   				y2 = edge2t->GetY();

   					}

					x3 = edge3f->GetX();
	   				y3 = edge3f->GetY();

	   				if ((x3 == x1 && y3 == y1) || (x3 == x2 && y3 == y2))
   					{
	   					x3 = edge3t->GetX();
	   					y3 = edge3t->GetY();

   					}
				}

				// Add an offset of half the Screen Width to the coords so that the polygon 
				// is centred.

				x1 = x1 + xo;
   				x2 = x2 + xo;
				x3 = x3 + xo;

   				y1 = y1 + yo;
				y2 = y2 + yo;
   				y3 = y3 + yo;
				  
				{
   					// Sort the Vertices such that (x1,y1) has the lowest y coord
					// (x2,y2) the next lowest and so on.

					int temp;
      				
					if (y2<y1)
					{
   	   					temp = y2;
      					y2 = y1;
         				y1 = temp;
						temp = x2;
   						x2 = x1;
      					x1 = temp;
				
					}
   					if (y3<y1)
      				{
      					temp = y3;
						y3 = y1;
   						y1 = temp;
						temp = x3;
         				x3 = x1;
						x1 = temp;
					}
   					if (y3<y2)
      				{
      					temp = y3;
						y3 = y2;
   						y2 = temp;
      					temp = x3;
         				x3 = x2;
						x2 = temp;

   					}
   				}
			DWORD colour = Face->GetColour(); // Read in the face colour.
			
			Fixed d = (Fixed)(x3 - x1) / (Fixed)(y3 - y1);
				
			Fixed x  = x1;
			int y  = y1;

			Fixed d0 = (Fixed)(x2 - x1) / (Fixed)(y2 - y1);
			Fixed x0 = x1;
			if (d < d0)
			{
				while (y < y2)
				{

					HLine(p,x,y,x0,colour); // Draw the Horizontal Line 
					y++;
					x  += d;
					x0 += d0;
				}
			}
			else
			{
				while (y < y2)
				{
					HLine(p,x0,y,x,colour); // Draw the Horizontal Line 
					y++;
					x  += d;
					x0 += d0;
					
				}
			}

			d0 = (Fixed)(x3 - x2) / (Fixed)(y3 - y2);
			
			x0 = x2;
			
			if (x < x0)
			{
				while (y < y3)
				{

					HLine(p,x,y,x0,colour);	// Draw the Horizontal Line 
					y++;
					x  += d;
					x0 += d0;
				}
			}
			else
			{
				while (y < y3)
				{
					
					HLine(p,x0,y,x,colour); // Draw the Horizontal Line 
					y++;
					x  += d;
					x0 += d0;
				}
			}
				
			}
				

		}
		/*********************************************************************************
		 *																				 *
		 *	The next Four Procedures do the same as above but now compare pixel 		 *
		 *  positions against a  Z-Buffer.  This provides a system where by polygons are *
		 *	clipped against each other, so no overlapping occurs.						 *
		 *																				 *
		 *********************************************************************************/


		// Write a coloured pixel at (x,y).
		void SetPixel(LPVOID pv,int next_scan, int x, int y, DWORD colour)
		{
			
			if (Bpp == 1) 
			{
				BYTE col = GetRGB8(colour);
			
				BYTE *p = (BYTE*)pv;
				p += (x + ((next_scan / Bpp) * y));
				*p = col;
			} else if (Bpp == 2) 
			{
				
				WORD col = GetRGB1624(colour);
				WORD *p = (WORD*)pv;
				p += (x + ((next_scan / Bpp) * y));
				*p = col;
			} else if (Bpp == 3)
			{
				DWORD col = GetRGB1624(colour);
				BYTE *p = (BYTE*)pv;
				p += ((x * Bpp) + ((next_scan) * y));
				*p = (col);
				p++;
				*p = (col >> 8);
				p++;
				*p = (col >> 16);
			} else if (Bpp == 4)
			{

				DWORD col = colour;
				DWORD *p = (DWORD*)pv;
				p += (x + ((next_scan / Bpp) * y));
				*p = col;
			}
			
			
		}

		// This not only draws a line between two points but also checks the line against
		// the Z-Buffer. 

		void HLineZ(LPVOID p, int next_scan,int x0, int y0, int z0, int x1, int y1, int z1, DWORD colour)
		{
			int scanpos = 0;
			int x = x0;
			Fixed z = z0;
			Fixed temp = -1;
			Fixed m = (Fixed)(z0 - z1) / (Fixed)(x0 - x1);
			
			if (x < MinClipX)
			{
				Fixed xDiff = (Fixed)MinClipX - (Fixed)x;
				z += (m * xDiff);
				x = MinClipX;
			}

			if (y1 == y0) {
				while (x < x1 && x < MaxClipX) 
				{
					scanpos = (x) + (ScreenX * y0);
					if ((int)z < -ZMin)  
					{
						// The following if block checks whether the value at that pixel 
						// position in the Z-Buffer is further away than the new one. 
						// If so it write the pixel.
						if (this->ZBuffer[scanpos] > ((int)z * -1)*((65536/ZRenderDepth)-1)) 
						{
							SetPixel(p,next_scan,x,y0,colour);
							this->ZBuffer[scanpos] = ((int)z * -1)*((65536/ZRenderDepth)-1);
						}
					}
					// Exit if both ends are too close.
					else if (((int)z >= -ZMin) && (z1>=-ZMin)) return; 
					x++;
					z += m;
				};
			}

		}

		// The differnece between this procedure and OZTriangle8 is that now a Z value is
		// being calculated so that the Z-Buffer can be populated.

		void OzTriangle8Z(LPVOID p, int next_scan, TFace *Face)
		{
   				
				{	
					int x1,y1,z1,x2,y2,z2,x3,y3,z3;			
				{

					T2dVertex *edge1f, *edge1t,*edge2f, *edge2t,*edge3f, *edge3t;
					{
						
						edge1f = Face->GetEdge1()->GetFrom2dVertex();
						edge1t = Face->GetEdge1()->GetTo2dVertex();
						
						edge2f = Face->GetEdge2()->GetFrom2dVertex();
						edge2t = Face->GetEdge2()->GetTo2dVertex();
						
			 			edge3f = Face->GetEdge3()->GetFrom2dVertex();
						edge3t = Face->GetEdge3()->GetTo2dVertex();
         				
					}
   					x1 = edge1f->GetX();
					y1 = edge1f->GetY();
					z1 = Face->GetEdge1()->GetFrom3dVertex()->GetZ();

					x2 = edge2f->GetX();
					y2 = edge2f->GetY();
					z2 = Face->GetEdge2()->GetFrom3dVertex()->GetZ();
					
					if (x2 == x1 && y2 == y1)
   					{
   						x2 = edge2t->GetX();
		   				y2 = edge2t->GetY();
						z2 = Face->GetEdge2()->GetTo3dVertex()->GetZ();
   					}

					x3 = edge3f->GetX();
	   				y3 = edge3f->GetY();
					z3 = Face->GetEdge3()->GetFrom3dVertex()->GetZ();

	   				if ((x3 == x1 && y3 == y1) || (x3 == x2 && y3 == y2))
   					{
	   					x3 = edge3t->GetX();
	   					y3 = edge3t->GetY();
						z3 = Face->GetEdge3()->GetTo3dVertex()->GetZ();
   					}
				}
				x1 = x1 + xo;
   				x2 = x2 + xo;
				x3 = x3 + xo;

   				y1 = y1 + yo;
				y2 = y2 + yo;
   				y3 = y3 + yo;
  
				{
   					int temp;
      				if (y2<y1)
					{
   	   					temp = y2;
      					y2 = y1;
         				y1 = temp;
						temp = x2;
   						x2 = x1;
      					x1 = temp;
						temp = z2;
   						z2 = z1;
      					z1 = temp;
				
					}
   					if (y3<y1)
      				{
      					temp = y3;
						y3 = y1;
   						y1 = temp;
						temp = x3;
         				x3 = x1;
						x1 = temp;
						temp = z3;
         				z3 = z1;
						z1 = temp;
					}
   					if (y3<y2)
      				{
      					temp = y3;
						y3 = y2;
   						y2 = temp;
      					temp = x3;
         				x3 = x2;
						x2 = temp;
						temp = z3;
         				z3 = z2;
						z2 = temp;

   					}
   				}
			
			
			

			DWORD colour = Face->GetColour();
			Fixed d = (Fixed)(x3 - x1) / (Fixed)(y3 - y1);
			Fixed dz;
			if ((z3-z1) != 0) dz = (Fixed)(z3 - z1) / (Fixed)(y3 - y1);
			else dz = 0;
			
    
			Fixed x  = x1;
			Fixed z = z1;

			int y  = y1;
			Fixed d0z;
			Fixed d0 = (Fixed)(x2 - x1) / (Fixed)(y2 - y1);
			if ((z2-z1) != 0) d0z = (Fixed)(z2 - z1) / (Fixed)(y2 - y1);
			else d0z = 0;
    
			Fixed x0 = x1;
			Fixed z0 = z1;
			
			if (y < MinClipY) 
			{
				Fixed Ydiff = (Fixed)MinClipY - (Fixed)y;

				z  += (dz  * Ydiff);
				z0 += (d0z * Ydiff);

				x  += (d   * Ydiff);
				x0 += (d0  * Ydiff);
				
				y   = MinClipY;
			}

			if (d < d0)
			{
				while (y < y2 && y < MaxClipY)
				{

					HLineZ(p,next_scan,x,y,z,x0,y,z0,colour);
					y++;
					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				
				}
			}
			else
			{
				while (y < y2 && y < MaxClipY)
				{
					HLineZ(p,next_scan,x0,y,z0,x,y,z,colour);
					y++;
					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
					
				}
			}
			if (y < MinClipY) 
			{
				Fixed Ydiff = (Fixed)MinClipY - (Fixed)y;

				z  += (dz  * Ydiff);
				z0 += (d0z * Ydiff);
				x  += (d   * Ydiff);
				x0 += (d0  * Ydiff);

				y   = MinClipY;
			}

			d0 = (Fixed)(x3 - x2) / (Fixed)(y3 - y2);
			if ((z3-z2) != 0) d0z = (Fixed)(z3 - z2) / (Fixed)(y3 - y2);
			else d0z = 0;
			x0 = x2;
			z0 = z2;
			if (x < x0)
			{
				while (y < y3 && y < MaxClipY)
				{

					HLineZ(p,next_scan,x,y,z,x0,y,z0,colour);
					y++;
					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				}
			}
			else
			{
				while (y < y3 && y < MaxClipY)
				{
					
					HLineZ(p,next_scan,x0,y,z0,x,y,z,colour);
					y++;
					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				}
			}


			}


		}

		/*********************************************************************************
		 *																				 *
		 *	The next Two Procedures do the same as above bu now provide linear			 *
		 *  interpolation of the colours (Gouraud Shading).  HLineZG uses the same		 *
		 *	SetPixel procedure as above.												 *
		 *																				 *
		 *********************************************************************************/

		void HLineZG(LPVOID p, int next_scan,int x0, int y0, int z0,Fixed r0,Fixed g0,Fixed b0, int x1, int y1, int z1, Fixed r1,Fixed g1,Fixed b1)
		{
			int scanpos = 0;
			int x = x0;
			Fixed z = z0;
			
			Fixed temp = -1;
			Fixed zm = (Fixed)(z0 - z1) / (Fixed)(x0 - x1);
			Fixed cr = r0;
			Fixed cg = g0;
			Fixed cb = b0;
			
			Fixed cmr = (Fixed)(r0 - r1) / (Fixed)(x0 - x1);
			Fixed cmg = (Fixed)(g0 - g1) / (Fixed)(x0 - x1);
			Fixed cmb = (Fixed)(b0 - b1) / (Fixed)(x0 - x1);

			if (x < MinClipX)
			{
				Fixed xDiff = (Fixed)MinClipX - (Fixed)x;
				
				z += (zm * xDiff);
				
				cr += (cmr * xDiff);
				cg += (cmg * xDiff);
				cb += (cmb * xDiff);

				x = MinClipX;

			}

			if (y1 == y0) {
				while (x < x1 && x < MaxClipX)
				{
					scanpos = (x) + (ScreenX * y0);
					if ((int)z < -ZMin)  
					{
						if ((this->ZBuffer[scanpos] > ((int)z * -1)*((65536/ZRenderDepth)-1)) && (ZBuf))
						{
							int r = (int)cr;
							int g = (int)cg;
							int b = (int)cb;

							DWORD tempcol = OzRGB(r,g,b);				
							
							SetPixel(p,next_scan,x,y0,tempcol);
							this->ZBuffer[scanpos] = ((int)z * -1)*((65536/ZRenderDepth)-1);
						}
						else if (!ZBuf) /*SetPixel(p,next_scan,x,y0,OzRGB(cr,cg,cb))*/;
					}
					else if (((int)z >= -ZMin) && (z1>=-ZMin)) return;
					x++;
					z += zm;

					cr += cmr;
					cg += cmg;
					cb += cmb;
				};
			}

		}

		// Now not only is a Z value stored but also a colour value.  The Colour value is
		// treated as another axis.

		void OzTriangle8ZG(LPVOID p,int next_scan, TFace *Face)
		{
   				
				{	
					int x1,y1,z1,x2,y2,z2,x3,y3,z3;
					DWORD c1,c2,c3;
					BYTE r1,r2,r3;
					BYTE g1,g2,g3;
					BYTE b1,b2,b3;
				{

					T2dVertex *edge1f, *edge1t,*edge2f, *edge2t,*edge3f, *edge3t;
					{
						
						edge1f = Face->GetEdge1()->GetFrom2dVertex();
						edge1t = Face->GetEdge1()->GetTo2dVertex();
						
						edge2f = Face->GetEdge2()->GetFrom2dVertex();
						edge2t = Face->GetEdge2()->GetTo2dVertex();
						
			 			edge3f = Face->GetEdge3()->GetFrom2dVertex();
						edge3t = Face->GetEdge3()->GetTo2dVertex();
         				
					}
   					x1 = edge1f->GetX();
					y1 = edge1f->GetY();
					z1 = Face->GetEdge1()->GetFrom3dVertex()->GetZ();
					c1 = Face->GetEdge1()->GetFrom3dVertex()->GetColour();
					r1 = Face->GetEdge1()->GetFrom3dVertex()->GetRed();
					g1 = Face->GetEdge1()->GetFrom3dVertex()->GetGreen();
					b1 = Face->GetEdge1()->GetFrom3dVertex()->GetBlue();

					x2 = edge2f->GetX();
					y2 = edge2f->GetY();
					z2 = Face->GetEdge2()->GetFrom3dVertex()->GetZ();
					c2 = Face->GetEdge2()->GetFrom3dVertex()->GetColour();
					r2 = Face->GetEdge2()->GetFrom3dVertex()->GetRed();
					g2 = Face->GetEdge2()->GetFrom3dVertex()->GetGreen();
					b2 = Face->GetEdge2()->GetFrom3dVertex()->GetBlue();

					if (x2 == x1 && y2 == y1)
   					{
   						x2 = edge2t->GetX();
		   				y2 = edge2t->GetY();
						z2 = Face->GetEdge2()->GetTo3dVertex()->GetZ();
						c2 = Face->GetEdge2()->GetTo3dVertex()->GetColour();
						r2 = Face->GetEdge2()->GetTo3dVertex()->GetRed();
						g2 = Face->GetEdge2()->GetTo3dVertex()->GetGreen();
						b2 = Face->GetEdge2()->GetTo3dVertex()->GetBlue();

   					}

					x3 = edge3f->GetX();
	   				y3 = edge3f->GetY();
					z3 = Face->GetEdge3()->GetFrom3dVertex()->GetZ();
					c3 = Face->GetEdge3()->GetFrom3dVertex()->GetColour();
					r3 = Face->GetEdge3()->GetFrom3dVertex()->GetRed();
					g3 = Face->GetEdge3()->GetFrom3dVertex()->GetGreen();
					b3 = Face->GetEdge3()->GetFrom3dVertex()->GetBlue();

	   				if ((x3 == x1 && y3 == y1) || (x3 == x2 && y3 == y2))
   					{
	   					x3 = edge3t->GetX();
	   					y3 = edge3t->GetY();
						z3 = Face->GetEdge3()->GetTo3dVertex()->GetZ();
						c3 = Face->GetEdge3()->GetTo3dVertex()->GetColour();
	   					r3 = Face->GetEdge3()->GetTo3dVertex()->GetRed();
						g3 = Face->GetEdge3()->GetTo3dVertex()->GetGreen();
						b3 = Face->GetEdge3()->GetTo3dVertex()->GetBlue();

					}
				}
				x1 = x1 + xo;
   				x2 = x2 + xo;
				x3 = x3 + xo;

   				y1 = y1 + yo;
				y2 = y2 + yo;
   				y3 = y3 + yo;
  
				{
   					int temp;
      				if (y2<y1)
					{
   	   					temp = y2;
      					y2 = y1;
         				y1 = temp;
						temp = x2;
   						x2 = x1;
      					x1 = temp;
						temp = z2;
   						z2 = z1;
      					z1 = temp;
						temp = c2;
   						c2 = c1;
      					c1 = temp;
						
						temp = r2;
						r2 = r1;
						r1 = temp;
						temp = g2;
						g2 = g1;
						g1 = temp;
						temp = b2;
						b2 = b1;
						b1 = temp;

				
					}
   					if (y3<y1)
      				{
      					temp = y3;
						y3 = y1;
   						y1 = temp;
						temp = x3;
         				x3 = x1;
						x1 = temp;
						temp = z3;
         				z3 = z1;
						z1 = temp;
						temp = c3;
         				c3 = c1;
						c1 = temp;
						
						temp = r3;
         				r3 = r1;
						r1 = temp;
						temp = g3;
         				g3 = g1;
						g1 = temp;
						temp = b3;
         				b3 = b1;
						b1 = temp;
									
	

					}
   					if (y3<y2)
      				{
      					temp = y3;
						y3 = y2;
   						y2 = temp;
      					temp = x3;
         				x3 = x2;
						x2 = temp;
						temp = z3;
         				z3 = z2;
						z2 = temp;
						temp = c3;
         				c3 = c2;
						c2 = temp;
						
						temp = r3;
         				r3 = r2;
						r2 = temp;
						temp = g3;
         				g3 = g2;
						g2 = temp;
						temp = b3;
         				b3 = b2;
						b2 = temp;
   					}
   				}
			
			Fixed d = (Fixed)(x3 - x1) / (Fixed)(y3 - y1);
			Fixed dz;
			if ((z3-z1) != 0) dz = (Fixed)(z3 - z1) / (Fixed)(y3 - y1);
			else dz = 0;
			
			Fixed dcr = (Fixed)(r3 - r1) / (Fixed)(y3 - y1);
			Fixed dcg = (Fixed)(g3 - g1) / (Fixed)(y3 - y1);
			Fixed dcb = (Fixed)(b3 - b1) / (Fixed)(y3 - y1);

			Fixed x  = x1;
			Fixed z = z1;
			
			Fixed cr = (Fixed)r1;
			Fixed cg = (Fixed)g1;
			Fixed cb = (Fixed)b1;

			int y  = y1;
			Fixed d0z;
			Fixed d0 = (Fixed)(x2 - x1) / (Fixed)(y2 - y1);
			
			if ((z2-z1) != 0) d0z = (Fixed)(z2 - z1) / (Fixed)(y2 - y1);
			else d0z = 0;
	
			Fixed d0cr = (Fixed)(r2 - r1) / (Fixed)(y2 - y1);
			Fixed d0cg = (Fixed)(g2 - g1) / (Fixed)(y2 - y1);
			Fixed d0cb = (Fixed)(b2 - b1) / (Fixed)(y2 - y1);

			Fixed x0 = x1;
			Fixed z0 = z1;
			
 			Fixed c0r = (Fixed)r1;
			Fixed c0g = (Fixed)g1;
			Fixed c0b = (Fixed)b1;

			if (y < MinClipY) 
			{
				Fixed Ydiff = (Fixed)MinClipY - (Fixed)y;
				
				z  += (dz  * Ydiff);
				z0 += (d0z * Ydiff);

				x  += (d   * Ydiff);
				x0 += (d0  * Ydiff);
				
				cr  += (dcr  * Ydiff);
				c0r += (d0cr * Ydiff); 
				cg  += (dcg  * Ydiff);
				c0g += (d0cg * Ydiff); 
				cb  += (dcb  * Ydiff);
				c0b += (d0cb * Ydiff); 
				
				y   = MinClipY;
			}

			if (d < d0)
			{
				while (y < y2 && y < MaxClipY)
				{

	
					HLineZG(p,next_scan,x,y,z,cr,cg,cb,x0,y,z0,c0r,c0g,c0b);
					y++;
				
					cr  += dcr;
					c0r += d0cr;
					cg  += dcg;
					c0g += d0cg;
					cb  += dcb;
					c0b += d0cb;
					
					z+= dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				}
			}
			else
			{
				while (y < y2 && y < MaxClipY)
				{
	
					HLineZG(p,next_scan,x0,y,z0,c0r,c0g,c0b,x,y,z,cr,cg,cb);
					y++;
	
					cr  += dcr;
					c0r += d0cr;
					cg  += dcg;
					c0g += d0cg;
					cb  += dcb;
					c0b += d0cb;

					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
					
				}
			}

			d0 = (Fixed)(x3 - x2) / (Fixed)(y3 - y2);
			if ((z3-z2) != 0) d0z = (Fixed)(z3 - z2) / (Fixed)(y3 - y2);
			else d0z = 0;
			
			d0cr = (Fixed)(r3 - r2) / (Fixed)(y3 - y2);
			d0cg = (Fixed)(g3 - g2) / (Fixed)(y3 - y2);
			d0cb = (Fixed)(b3 - b2) / (Fixed)(y3 - y2);

			x0 = x2;
			z0 = z2;
			
			c0r = (Fixed)r2;
			c0g = (Fixed)g2;
			c0b = (Fixed)b2;

			if (y < MinClipY) 
			{
				Fixed Ydiff = (Fixed)MinClipY - (Fixed)y;
				
				float fYdiff = MinClipY - y;
				
				z  += (dz  * Ydiff);
				z0 += (d0z * Ydiff);

				x  += (d   * Ydiff);
				x0 += (d0  * Ydiff);

				cr  += (dcr  * Ydiff);
				c0r += (d0cr * Ydiff); 
				cg  += (dcg  * Ydiff);
				c0g += (d0cg * Ydiff); 
				cb  += (dcb  * Ydiff);
				c0b += (d0cb * Ydiff); 
							
				y   = MinClipY;
			}

			if (x < x0)
			{
				while (y < y3 && y < MaxClipY)
				{
					
					HLineZG(p,next_scan,x,y,z,cr,cg,cb,x0,y,z0,c0r,c0g,c0b);
					y++;
	
					cr  += dcr;
					c0r += d0cr;
					cg  += dcg;
					c0g += d0cg;
					cb  += dcb;
					c0b += d0cb;

					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				}
			}
			else
			{
				while (y < y3 && y < MaxClipY)
				{
					HLineZG(p,next_scan,x0,y,z0,c0r,c0g,c0b,x,y,z,cr,cg,cb);
					y++;
	
					cr  += dcr;
					c0r += d0cr;
					cg  += dcg;
					c0g += d0cg;
					cb  += dcb;
					c0b += d0cb;

					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				}
			}


			}


		}
		void HLineZF(LPVOID p, int next_scan,int x0, int y0, int z0,Fixed r0,Fixed g0,Fixed b0, int x1, int y1, int z1, Fixed r1,Fixed g1,Fixed b1)
		{
			int scanpos = 0;
			int x = x0;
			Fixed z = z0;
			
			Fixed temp = -1;
			Fixed zm = (Fixed)(z0 - z1) / (Fixed)(x0 - x1);
			
			Fixed cr = r0;
			Fixed cg = g0;
			Fixed cb = b0;
			
			Fixed cmr = (Fixed)(r0 - r1) / (Fixed)(x0 - x1);
			Fixed cmg = (Fixed)(g0 - g1) / (Fixed)(x0 - x1);
			Fixed cmb = (Fixed)(b0 - b1) / (Fixed)(x0 - x1);
			
			if (x < MinClipX)
			{
				Fixed xDiff = (Fixed)MinClipX - (Fixed)x;
				
				z += (zm * xDiff);
				
				cr += (cmr * xDiff);
				cg += (cmg * xDiff);
				cb += (cmb * xDiff);

				x = MinClipX;

			}

			if (y1 == y0) {
				while (x < x1 && x < MaxClipX)
				{
					scanpos = (x) + (ScreenX * y0);
					if ((int)z < -ZMin)  
					{
						if ((this->ZBuffer[scanpos] > ((int)z * -1)*((65536/ZRenderDepth)-1)) && (ZBuf))
						{
							int fmr = (int)(((cr - (Fixed)Fogr) / (Fixed)(-ZRenderDepth)) * z);
							int fmg = (int)(((cg - (Fixed)Fogg) / (Fixed)(-ZRenderDepth)) * z);
							int fmb = (int)(((cb - (Fixed)Fogb) / (Fixed)(-ZRenderDepth)) * z);
					
							int r = (int)cr - fmr;
							int g = (int)cg - fmg;
							int b = (int)cb - fmb;

							if (Fogr == 0) 
							{
								if (r < 0) r = Fogr;
							}
							else 
							{
								if (r > 255) r = Fogr;
							}
							if (Fogg == 0) 
							{
								if (g < 0) g = Fogg;
							}
							else 
							{
								if (g > 255) g = Fogg;
							}
							if (Fogb == 0) 
							{
								if (b < 0) b = Fogb;
							}
							else 
							{
								if (b > 255) b = Fogb;
							}
							
							
							

							DWORD tempcol = OzRGB(r,g,b);				
							
							SetPixel(p,next_scan,x,y0,tempcol);
							this->ZBuffer[scanpos] = ((int)z * -1)*((65536/ZRenderDepth)-1);
						}
						else if (!ZBuf) /*SetPixel(p,next_scan,x,y0,OzRGB(cr,cg,cb))*/;
					}
					else if (((int)z >= -ZMin) && (z1>=-ZMin)) return;
					x++;
					z += zm;

					cr += cmr;
					cg += cmg;
					cb += cmb;
				};
			}

		}

		// Now not only is a Z value stored but also a colour value.  The Colour value is
		// treated as another axis.

		void OzTriangle8ZF(LPVOID p,int next_scan, TFace *Face)
		{
   				
				{	
					int x1,y1,z1,x2,y2,z2,x3,y3,z3;
					DWORD c1,c2,c3;
					BYTE r1,r2,r3;
					BYTE g1,g2,g3;
					BYTE b1,b2,b3;
				{

					T2dVertex *edge1f, *edge1t,*edge2f, *edge2t,*edge3f, *edge3t;
					{
						
						edge1f = Face->GetEdge1()->GetFrom2dVertex();
						edge1t = Face->GetEdge1()->GetTo2dVertex();
						
						edge2f = Face->GetEdge2()->GetFrom2dVertex();
						edge2t = Face->GetEdge2()->GetTo2dVertex();
						
			 			edge3f = Face->GetEdge3()->GetFrom2dVertex();
						edge3t = Face->GetEdge3()->GetTo2dVertex();
         				
					}
   					x1 = edge1f->GetX();
					y1 = edge1f->GetY();
					z1 = Face->GetEdge1()->GetFrom3dVertex()->GetZ();
					c1 = Face->GetEdge1()->GetFrom3dVertex()->GetColour();
					r1 = Face->GetEdge1()->GetFrom3dVertex()->GetRed();
					g1 = Face->GetEdge1()->GetFrom3dVertex()->GetGreen();
					b1 = Face->GetEdge1()->GetFrom3dVertex()->GetBlue();

					x2 = edge2f->GetX();
					y2 = edge2f->GetY();
					z2 = Face->GetEdge2()->GetFrom3dVertex()->GetZ();
					c2 = Face->GetEdge2()->GetFrom3dVertex()->GetColour();
					r2 = Face->GetEdge2()->GetFrom3dVertex()->GetRed();
					g2 = Face->GetEdge2()->GetFrom3dVertex()->GetGreen();
					b2 = Face->GetEdge2()->GetFrom3dVertex()->GetBlue();

					if (x2 == x1 && y2 == y1)
   					{
   						x2 = edge2t->GetX();
		   				y2 = edge2t->GetY();
						z2 = Face->GetEdge2()->GetTo3dVertex()->GetZ();
						c2 = Face->GetEdge2()->GetTo3dVertex()->GetColour();
						r2 = Face->GetEdge2()->GetTo3dVertex()->GetRed();
						g2 = Face->GetEdge2()->GetTo3dVertex()->GetGreen();
						b2 = Face->GetEdge2()->GetTo3dVertex()->GetBlue();

   					}

					x3 = edge3f->GetX();
	   				y3 = edge3f->GetY();
					z3 = Face->GetEdge3()->GetFrom3dVertex()->GetZ();
					c3 = Face->GetEdge3()->GetFrom3dVertex()->GetColour();
					r3 = Face->GetEdge3()->GetFrom3dVertex()->GetRed();
					g3 = Face->GetEdge3()->GetFrom3dVertex()->GetGreen();
					b3 = Face->GetEdge3()->GetFrom3dVertex()->GetBlue();

	   				if ((x3 == x1 && y3 == y1) || (x3 == x2 && y3 == y2))
   					{
	   					x3 = edge3t->GetX();
	   					y3 = edge3t->GetY();
						z3 = Face->GetEdge3()->GetTo3dVertex()->GetZ();
						c3 = Face->GetEdge3()->GetTo3dVertex()->GetColour();
	   					r3 = Face->GetEdge3()->GetTo3dVertex()->GetRed();
						g3 = Face->GetEdge3()->GetTo3dVertex()->GetGreen();
						b3 = Face->GetEdge3()->GetTo3dVertex()->GetBlue();

					}
				}
				x1 = x1 + xo;
   				x2 = x2 + xo;
				x3 = x3 + xo;

   				y1 = y1 + yo;
				y2 = y2 + yo;
   				y3 = y3 + yo;
  
				{
   					int temp;
      				if (y2<y1)
					{
   	   					temp = y2;
      					y2 = y1;
         				y1 = temp;
						temp = x2;
   						x2 = x1;
      					x1 = temp;
						temp = z2;
   						z2 = z1;
      					z1 = temp;
						temp = c2;
   						c2 = c1;
      					c1 = temp;
						
						temp = r2;
						r2 = r1;
						r1 = temp;
						temp = g2;
						g2 = g1;
						g1 = temp;
						temp = b2;
						b2 = b1;
						b1 = temp;

				
					}
   					if (y3<y1)
      				{
      					temp = y3;
						y3 = y1;
   						y1 = temp;
						temp = x3;
         				x3 = x1;
						x1 = temp;
						temp = z3;
         				z3 = z1;
						z1 = temp;
						temp = c3;
         				c3 = c1;
						c1 = temp;
						
						temp = r3;
         				r3 = r1;
						r1 = temp;
						temp = g3;
         				g3 = g1;
						g1 = temp;
						temp = b3;
         				b3 = b1;
						b1 = temp;
									
	

					}
   					if (y3<y2)
      				{
      					temp = y3;
						y3 = y2;
   						y2 = temp;
      					temp = x3;
         				x3 = x2;
						x2 = temp;
						temp = z3;
         				z3 = z2;
						z2 = temp;
						temp = c3;
         				c3 = c2;
						c2 = temp;
						
						temp = r3;
         				r3 = r2;
						r2 = temp;
						temp = g3;
         				g3 = g2;
						g2 = temp;
						temp = b3;
         				b3 = b2;
						b2 = temp;
   					}
   				}
			
			Fixed d = (Fixed)(x3 - x1) / (Fixed)(y3 - y1);
			Fixed dz;
			if ((z3-z1) != 0) dz = (Fixed)(z3 - z1) / (Fixed)(y3 - y1);
			else dz = 0;
			
			Fixed dcr = (Fixed)(r3 - r1) / (Fixed)(y3 - y1);
			Fixed dcg = (Fixed)(g3 - g1) / (Fixed)(y3 - y1);
			Fixed dcb = (Fixed)(b3 - b1) / (Fixed)(y3 - y1);

			Fixed x  = x1;
			Fixed z = z1;
			
			Fixed cr = (Fixed)r1;
			Fixed cg = (Fixed)g1;
			Fixed cb = (Fixed)b1;

			int y  = y1;
			Fixed d0z;
			Fixed d0 = (Fixed)(x2 - x1) / (Fixed)(y2 - y1);
			
			if ((z2-z1) != 0) d0z = (Fixed)(z2 - z1) / (Fixed)(y2 - y1);
			else d0z = 0;
	
			Fixed d0cr = (Fixed)(r2 - r1) / (Fixed)(y2 - y1);
			Fixed d0cg = (Fixed)(g2 - g1) / (Fixed)(y2 - y1);
			Fixed d0cb = (Fixed)(b2 - b1) / (Fixed)(y2 - y1);

			Fixed x0 = x1;
			Fixed z0 = z1;
			
 			Fixed c0r = (Fixed)r1;
			Fixed c0g = (Fixed)g1;
			Fixed c0b = (Fixed)b1;

			if (y < MinClipY) 
			{
				Fixed Ydiff = (Fixed)MinClipY - (Fixed)y;
				
				z  += (dz  * Ydiff);
				z0 += (d0z * Ydiff);

				x  += (d   * Ydiff);
				x0 += (d0  * Ydiff);
				
				cr  += (dcr  * Ydiff);
				c0r += (d0cr * Ydiff); 
				cg  += (dcg  * Ydiff);
				c0g += (d0cg * Ydiff); 
				cb  += (dcb  * Ydiff);
				c0b += (d0cb * Ydiff); 
				
				y   = MinClipY;
			}

			if (d < d0)
			{
				while (y < y2 && y < MaxClipY)
				{

	
					HLineZF(p,next_scan,x,y,z,cr,cg,cb,x0,y,z0,c0r,c0g,c0b);
					y++;
				
					cr  += dcr;
					c0r += d0cr;
					cg  += dcg;
					c0g += d0cg;
					cb  += dcb;
					c0b += d0cb;
					
					z+= dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				}
			}
			else
			{
				while (y < y2 && y < MaxClipY)
				{
	
					HLineZF(p,next_scan,x0,y,z0,c0r,c0g,c0b,x,y,z,cr,cg,cb);
					y++;
	
					cr  += dcr;
					c0r += d0cr;
					cg  += dcg;
					c0g += d0cg;
					cb  += dcb;
					c0b += d0cb;

					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
					
				}
			}

			d0 = (Fixed)(x3 - x2) / (Fixed)(y3 - y2);
			if ((z3-z2) != 0) d0z = (Fixed)(z3 - z2) / (Fixed)(y3 - y2);
			else d0z = 0;
			
			d0cr = (Fixed)(r3 - r2) / (Fixed)(y3 - y2);
			d0cg = (Fixed)(g3 - g2) / (Fixed)(y3 - y2);
			d0cb = (Fixed)(b3 - b2) / (Fixed)(y3 - y2);

			x0 = x2;
			z0 = z2;
			
			c0r = (Fixed)r2;
			c0g = (Fixed)g2;
			c0b = (Fixed)b2;

			if (y < MinClipY) 
			{
				Fixed Ydiff = (Fixed)MinClipY - (Fixed)y;
				
				float fYdiff = MinClipY - y;
				
				z  += (dz  * Ydiff);
				z0 += (d0z * Ydiff);

				x  += (d   * Ydiff);
				x0 += (d0  * Ydiff);

				cr  += (dcr  * Ydiff);
				c0r += (d0cr * Ydiff); 
				cg  += (dcg  * Ydiff);
				c0g += (d0cg * Ydiff); 
				cb  += (dcb  * Ydiff);
				c0b += (d0cb * Ydiff); 
							
				y   = MinClipY;
			}

			if (x < x0)
			{
				while (y < y3 && y < MaxClipY)
				{
					
					HLineZF(p,next_scan,x,y,z,cr,cg,cb,x0,y,z0,c0r,c0g,c0b);
					y++;
	
					cr  += dcr;
					c0r += d0cr;
					cg  += dcg;
					c0g += d0cg;
					cb  += dcb;
					c0b += d0cb;

					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				}
			}
			else
			{
				while (y < y3 && y < MaxClipY)
				{
					HLineZF(p,next_scan,x0,y,z0,c0r,c0g,c0b,x,y,z,cr,cg,cb);
					y++;
	
					cr  += dcr;
					c0r += d0cr;
					cg  += dcg;
					c0g += d0cg;
					cb  += dcb;
					c0b += d0cb;

					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				}
			}


			}


		}
		/*********************************************************************************
		 *																				 *
		 *	The next Two Procedures do the same as the Z-Buffer algorithm but now		 *
		 *  map a texture on to the polygon surface.  Again this uses the same SetPixel  *
		 *  routine.  N.B. The texture is skewed at certain angles and Texture			 *
		 *	perspective corrections is inverted.  Try it and see.						 *
		 *																				 *
		 *********************************************************************************/

		void GetTexCoord(Fixed s, Fixed t, Fixed z, Fixed &TexPosX, Fixed &TexPosY, DWORD *Texture, int TexX, int TexY,bool Persp = false)
		{
			Fixed sa;
			Fixed ta;
			
			if (Persp)
			{
				//z = z * (Fixed) -1;
				/*sa = (Fixed)(prp) * ((s * (Fixed) -1) / ((Fixed)-ZRenderDepth + (z * (Fixed) -1))) * (Fixed) -4;
				ta = (Fixed)(prp) * ((t * (Fixed) -1) / ((Fixed)-ZRenderDepth + (z * (Fixed) -1))) * (Fixed) -4;*/
				
				sa = (Fixed)(prp) * (s / z);
				ta = (Fixed)(prp) * (t / z);
				
				sa = s - sa;
				ta = t - ta;
			}	
			else 
			{
				sa = s;
				ta = t;
			}
			if ((int)sa >= 0)
			{
				TexPosX = TexX - ((int)(sa)  % TexX) - 1 ; // Correct for positive x coords
				
			}
			else 
			{
				TexPosX = (((int)sa % -TexX) * -1); // Correct for negative x coords
			}
			if ((int)ta >= 0)
			{
				TexPosY = TexY - ((int)ta % TexY) - 1; // Correct for positive y coords
			}
			else 
			{
				TexPosY = (((int)ta  % -TexY) * -1); // Correct for negative y coords
			}

		}
		void HLineZT(LPVOID p, int next_scan, int x0, int y0, int z0, Fixed s0, Fixed t0, int x1, int y1, int z1, Fixed s1, Fixed t1, DWORD *Texture, int TexX, int TexY)
		{
			int scanpos = 0;
			int x = x0;
			
			Fixed s = s0;
			Fixed t = t0;
			Fixed z = z0;

			Fixed m = (Fixed)(z0 - z1) / (Fixed)(x0 - x1);

			Fixed ds = (Fixed)(s0 - s1) / (Fixed)(x0 - x1);

			Fixed dt = (Fixed)(t0 - t1) / (Fixed)(x0 - x1);


			Fixed TexPosX = (Fixed)0;
			Fixed TexPosY = (Fixed)0;
			
			if (x < MinClipX)
			{
				Fixed xdiff = (Fixed)(MinClipX - x);
				z += (m * xdiff);
				s += (ds * xdiff);
				t += (dt * xdiff);
				x = MinClipX;
			}
			if (y1 == y0) {
				while (x < x1 && x < MaxClipX ) 
				{
					scanpos = (x) + (ScreenX * y0);
					
					
					if ((int)z < -ZMin)  
					{
						if ((this->ZBuffer[scanpos] > ((int)z * -1)*((65536/ZRenderDepth)-1)) && (ZBuf))
						{
							GetTexCoord(s,t,z,TexPosX,TexPosY,Texture,TexX,TexY,perspective);
							// Write the correct Texel.
							SetPixel(p,next_scan,x,y0,Texture[(int)(TexPosX + (TexPosY * (Fixed)TexX))]);
							this->ZBuffer[scanpos] = ((int)z * -1)*((65536/ZRenderDepth)-1);
						}
						else if (!ZBuf) 
						{
							GetTexCoord(s,t,z,TexPosX,TexPosY,Texture,TexX,TexY,perspective);
						
							SetPixel(p,next_scan,x,y0,Texture[(int)(TexPosX + (TexPosY * (Fixed)TexX))]);
						}
					}
					else if (((int)z >= -ZMin) && (z1>=-ZMin)) return;
					x++;
					
					s += ds;
					t += dt;
					z += m;

				};
			}

		}

		// Now instead of a colour axis we have two more s and t. These are traversed as if the
		// polygon had not been rotated so that the texture orientation is correct.

		void OzTriangle8ZT(LPVOID p, int next_scan, TFace *Face)
		{
   				
				{	
					int x1,y1,z1,s1,t1,x2,y2,z2,s2,t2,x3,y3,z3,s3,t3;			
				{

					T2dVertex *edge1f, *edge1t,*edge2f, *edge2t,*edge3f, *edge3t;
					{
						
						edge1f = Face->GetEdge1()->GetFrom2dVertex();
						edge1t = Face->GetEdge1()->GetTo2dVertex();
						
						edge2f = Face->GetEdge2()->GetFrom2dVertex();
						edge2t = Face->GetEdge2()->GetTo2dVertex();
						
			 			edge3f = Face->GetEdge3()->GetFrom2dVertex();
						edge3t = Face->GetEdge3()->GetTo2dVertex();
         				
					}
   					x1 = edge1f->GetX();
					y1 = edge1f->GetY();
					z1 = Face->GetEdge1()->GetFrom3dVertex()->GetZ();
					s1 = Face->GetEdge1()->GetFromVertex()->GetS();
					t1 = Face->GetEdge1()->GetFromVertex()->GetT();

					x2 = edge2f->GetX();
					y2 = edge2f->GetY();
					z2 = Face->GetEdge2()->GetFrom3dVertex()->GetZ();
					s2 = Face->GetEdge2()->GetFromVertex()->GetS();
					t2 = Face->GetEdge2()->GetFromVertex()->GetT();

					if (x2 == x1 && y2 == y1)
   					{
   						x2 = edge2t->GetX();
		   				y2 = edge2t->GetY();
						z2 = Face->GetEdge2()->GetTo3dVertex()->GetZ();
						s2 = Face->GetEdge2()->GetToVertex()->GetS();
						t2 = Face->GetEdge2()->GetToVertex()->GetT();
  					}

					x3 = edge3f->GetX();
	   				y3 = edge3f->GetY();
					z3 = Face->GetEdge3()->GetFrom3dVertex()->GetZ();
					s3 = Face->GetEdge3()->GetFromVertex()->GetS();
					t3 = Face->GetEdge3()->GetFromVertex()->GetT();

	   				if ((x3 == x1 && y3 == y1) || (x3 == x2 && y3 == y2))
   					{
	   					x3 = edge3t->GetX();
	   					y3 = edge3t->GetY();
						z3 = Face->GetEdge3()->GetTo3dVertex()->GetZ();
						s3 = Face->GetEdge3()->GetToVertex()->GetS();
						t3 = Face->GetEdge3()->GetToVertex()->GetT();

   					}
				}
				x1 = x1 + xo;
   				x2 = x2 + xo;
				x3 = x3 + xo;

   				y1 = y1 + yo;
				y2 = y2 + yo;
   				y3 = y3 + yo;
  
				{
   					int temp;
      				if (y2<y1)
					{
   	   					temp = y2;
      					y2 = y1;
         				y1 = temp;
						temp = x2;
   						x2 = x1;
      					x1 = temp;
						temp = z2;
   						z2 = z1;
      					z1 = temp;
						
						temp = s2;
   						s2 = s1;
      					s1 = temp;
						temp = t2;
   						t2 = t1;
      					t1 = temp;
						
					}
   					if (y3<y1)
      				{
      					temp = y3;
						y3 = y1;
   						y1 = temp;
						temp = x3;
         				x3 = x1;
						x1 = temp;
						temp = z3;
         				z3 = z1;
						z1 = temp;
						
						temp = s3;
						s3 = s1;
   						s1 = temp;
						temp = t3;
         				t3 = t1;
						t1 = temp;
					}
   					if (y3<y2)
      				{
      					temp = y3;
						y3 = y2;
   						y2 = temp;
      					temp = x3;
         				x3 = x2;
						x2 = temp;
						temp = z3;
         				z3 = z2;
						z2 = temp;
						
						temp = s3;
						s3 = s2;
   						s2 = temp;
      					temp = t3;
         				t3 = t2;
						t2 = temp;


   					}
   				}
			Fixed x  = x1;
			Fixed z = z1;
			
			Fixed s = s1;
			Fixed t = t1;
    
			Fixed dz;

			Fixed d = (Fixed)(x3 - x1) / (Fixed)(y3 - y1);
			if ((z3-z1) != 0) dz = (Fixed)(z3 - z1) / (Fixed)(y3 - y1);
			else dz = 0;
			
    
			Fixed ds = (Fixed)(s3 - s1) / (Fixed)(y3 - y1);
			Fixed dt = (Fixed)(t3 - t1) / (Fixed)(y3 - y1);
			
			int y  = y1;
		
			Fixed x0 = x1;
			Fixed z0 = z1;
			
			Fixed s0 = s1;
			Fixed t0 = t1;

			Fixed d0z;
			Fixed d0 = (Fixed)(x2 - x1) / (Fixed)(y2 - y1);

			if ((z2-z1) != 0) d0z = (Fixed)(z2 - z1) / (Fixed)(y2 - y1);
			else d0z = 0;
			
			Fixed d0s = (Fixed)(s2 - s1) / (Fixed)(y2 - y1);
			Fixed d0t = (Fixed)(t2 - t1) / (Fixed)(y2 - y1);

			if (y < MinClipY)
			{
				Fixed Ydiff = (Fixed)MinClipY - (Fixed)y;

				z  += (dz  * Ydiff);
				z0 += (d0z * Ydiff);

				x  += (d   * Ydiff);
				x0 += (d0  * Ydiff);

				s  += (ds  * Ydiff);
				s0 += (d0s * Ydiff);

				t  += (dt  * Ydiff);
				t0 += (d0t * Ydiff);
				
				y   = MinClipY;
			}

			if (d < d0)
			{
				while (y < y2 && y < MaxClipY)
				{

					HLineZT(p,next_scan,x,y,z,s,t,x0,y,z0,s0,t0,Face->GetTexture(),Face->GetTexX(),Face->GetTexY());
          
					y++;
					
					t  += dt;
					t0 += d0t;
				
					s  += ds; 
					s0 += d0s;

					z  += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				}
			}
			else
			{
				while (y < y2 && y < MaxClipY)
				{
					HLineZT(p,next_scan,x0,y,z0,s0,t0,x,y,z,s,t,Face->GetTexture(),Face->GetTexX(),Face->GetTexY());

					y++;
					
					t += dt;
					t0 += d0t;
					
					s += ds;
					s0 += d0s;
					
					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
					
				}
			}

			d0 = (Fixed)(x3 - x2) / (Fixed)(y3 - y2);
			if ((z3-z2) != 0) d0z = (Fixed)(z3 - z2) / (Fixed)(y3 - y2);
			else d0z = 0;
    
			d0s = (Fixed)(s3 - s2) / (Fixed)(y3 - y2);
			d0t = ((Fixed)(t3 - t2) / (Fixed)(y3 - y2));

			x0 = x2;
			z0 = z2;
			s0 = s2;
			t0 = t2;
			if (y < MinClipY)
			{
				Fixed Ydiff = (Fixed)MinClipY - (Fixed)y;

				z  += (dz  * Ydiff);
				z0 += (d0z * Ydiff);

				x  += (d   * Ydiff);
				x0 += (d0  * Ydiff);

				s  += (ds  * Ydiff);
				s0 += (d0s * Ydiff);

				t  += (dt  * Ydiff);
				t0 += (d0t * Ydiff);
				
				y   = MinClipY;
			}
			if (x < x0)
			{
				while (y < y3 && y < MaxClipY)
				{

					HLineZT(p,next_scan,x,y,z,s,t,x0,y,z0,s0,t0,Face->GetTexture(),Face->GetTexX(),Face->GetTexY());
					
					y++;
					
					t += dt;
					t0 += d0t;
					
					s += ds;
					s0 += d0s;
					
					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				}
			}
			else
			{
				while (y < y3 && y < MaxClipY)
				{
					
					HLineZT(p,next_scan,x0,y,z0,s0,t0,x,y,z,s,t,Face->GetTexture(),Face->GetTexX(),Face->GetTexY());
					
					y++;
					
					t += dt;
					t0 += d0t;
					
					s += ds;
					s0 += d0s;
					
					z += dz;
					z0 += d0z;
					x  += d;
					x0 += d0;
				}
			}


			}

		}

		void ReleaseAllObjects(void)
		{
			if (g_pDD != NULL)
			{
				if (Primary != NULL)
				{
					Primary->Release();
					Primary = NULL;
				}
				if (Back != NULL)
				{
					Back->Release();
					Back = NULL;
				}
				g_pDD->Release();
				g_pDD = NULL;
			}
		}
		HRESULT	InitFail(HWND hWnd, HRESULT hRet, LPCTSTR szError,...)
		{
			char                        szBuff[128];
			va_list                     vl;

			va_start(vl, szError);
			vsprintf(szBuff, szError, vl);
			ReleaseAllObjects();
			MessageBox(hWnd, szBuff, "An Error has Occurred", MB_OK);
			DestroyWindow(hWnd);
			va_end(vl);
			return hRet;
		}
		


	public:
		TDDraw() {}

		HRESULT TDDrawInit(HINSTANCE hInstance, int nCmdShow, int minClipX = 0, int maxClipX = 640, int minClipY = 0, int maxClipY = 480,  __int16 screenX = 640, __int16 screenY = 480, int bpp = 8, char *Name = "", char *Title = "" ) 		
		{
			ScreenX		= screenX;
			ScreenY		= screenY;
			Bpp			= bpp / 8;
			ScreenSize	= ScreenX * ScreenY;

			this->MinClipX = minClipX;
			this->MaxClipX = maxClipX; 
			
			this->MinClipY = minClipY;
			this->MaxClipY = maxClipY; 
		
			xo			= ((MaxClipX - MinClipX) /2 ) + MinClipX;
			yo			= ((MaxClipY - MinClipY) /2 ) + MinClipY;
/*          xo			= ScreenX /2;
			yo			= ScreenY /2;*/
		   

			DDSCAPS2                    ddscaps;
			HRESULT                     hRet;
			LPDIRECTDRAW                pDD;
			MSG                         msg;
			WNDCLASS                    wc;
					
			wc.style			= CS_HREDRAW | CS_VREDRAW;
			wc.lpfnWndProc		= ::WindowProc;
			wc.cbClsExtra		= 0;
			wc.cbWndExtra		= 0;
			wc.hInstance		= hInstance;
			wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MAIN_ICON));
			wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
			wc.hbrBackground	= (HBRUSH )GetStockObject(BLACK_BRUSH);
			wc.lpszMenuName		= Name;
			wc.lpszClassName	= Name;
			RegisterClass(&wc);

			// Create a window
			hWnd = CreateWindowEx(WS_EX_TOPMOST,
								  Name,
								  Title,
								  WS_POPUP,
								  0,
								  0,
								  GetSystemMetrics(SM_CXSCREEN),
								  GetSystemMetrics(SM_CYSCREEN),
								  NULL,
								  NULL,
								  hInstance,
								  NULL);

			
			if (!hWnd)
				return false;
			ShowWindow(hWnd, nCmdShow);
			UpdateWindow(hWnd);
			SetFocus(hWnd);	
			 
			if (DirectDrawCreate(NULL, &pDD, NULL) != DD_OK)
				return InitFail(hWnd, hRet, "DirectDrawCreate FAILED");
			// Fetch DirectDraw4 interface
			if (pDD->QueryInterface(IID_IDirectDraw4, (LPVOID *) & g_pDD) != DD_OK)
				return InitFail(hWnd, hRet, "QueryInterface FAILED");

			// Get exclusive mode
			if (g_pDD->SetCooperativeLevel(hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN) != DD_OK)
				return InitFail(hWnd, hRet, "SetCooperativeLevel FAILED");

			if (g_pDD->SetDisplayMode(ScreenX, ScreenY, bpp, 0, 0) != DD_OK)
			{
				if (g_pDD->SetDisplayMode(ScreenX, ScreenY, bpp - 8, 0, 0) != DD_OK)
				{
					char ch[50];
					sprintf(ch,"SetDisplayMode Failed in %dx%dx%d & in %dx%dx%d", ScreenX, ScreenY, bpp, ScreenX, ScreenY, bpp);
					return InitFail(hWnd, hRet, ch);
				}
			}
			// Create the primary surface with 1 back buffer

			ZeroMemory(&ddsd, sizeof(ddsd));
			ddsd.dwSize = sizeof(ddsd);
			ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
			ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
				DDSCAPS_FLIP |
				DDSCAPS_COMPLEX;
			ddsd.dwBackBufferCount = 1;
    
			if (g_pDD->CreateSurface(&ddsd, &Primary, NULL) != DD_OK)
				return InitFail(hWnd, hRet, "CreateSurface FAILED");

			// Get a pointer to the back buffer
			ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
			if (Primary->GetAttachedSurface(&ddscaps, &Back) != DD_OK)
				return InitFail(hWnd, hRet, "GetAttachedSurface FAILED");
  
			HDC hdc = GetDC(NULL);
    
			if (GetDeviceCaps(hdc, RASTERCAPS) & RC_PALETTE)
			{
				unsigned __int8 ir = 0, ig = 0, ib = 0,i = 0;
						
				while (ir < 8)
				{
					ig = 0;
					while (ig < 4)
					{
						ib = 0;
						while (ib < 8)
						{
							ape[i].peRed   = (256 / 8) * ir;
							ape[i].peGreen = (256 / 4) * ig;
							ape[i].peBlue  = (256 / 8) * ib;
							ib++;
							i++;
						};
					    ig++;
					};
					ir++;
				};

				if (g_pDD->CreatePalette(DDPCAPS_8BIT, ape, &Palette, NULL) == DD_OK)
					Primary->SetPalette(Palette);
        
			}
			ReleaseDC(NULL, hdc);

			pf.dwSize = sizeof(DDPIXELFORMAT);

			Primary->GetPixelFormat(&pf);

			rshift = GetNumberofBits(pf.dwRBitMask);
			gshift = GetNumberofBits(pf.dwGBitMask);
			bshift = GetNumberofBits(pf.dwBBitMask);

			this->ZBuf = false;
			this->ZInit = false;
			this->Gouraud = false;
			this->Texture = false;
			this->perspective = false;
			this->Fog = false;
			this->Fogr = 0;
			this->Fogg = 0;
			this->Fogb = 0;
			
			ZMin = 50;
			ZRenderDepth = 4096;
			
			ddsd.dwSize = sizeof(ddsd);
			
			return DD_OK;
		}
			
		~TDDraw()
		{
			
			ReleaseAllObjects();
			if (this->ZInit) delete[] ZBuffer;
		}
		
		HRESULT NewResolution(int screenX, int screenY, int bpp)
	{
			ScreenX = screenX;
			ScreenY = screenY;

			DDSCAPS2                    ddscaps;
			HRESULT                     hRet;

			if (Back)    Back->Release()   ,    Back    = NULL;
			if (Primary) Primary->Release(),    Primary = NULL;
			if (Palette) Palette->Release(),    Palette = NULL;

			Bpp = bpp /8;

			if (g_pDD->SetDisplayMode(ScreenX, ScreenY, bpp, 0, 0) != DD_OK)
			{
				Bpp = (bpp - 8) / 8;
				if (g_pDD->SetDisplayMode(ScreenX, ScreenY, bpp - 8, 0, 0) != DD_OK)
				{
					
					char ch[50];
					sprintf(ch,"SetDisplayMode Failed in %dx%dx%d & in %dx%dx%d", ScreenX, ScreenY, bpp, ScreenX, ScreenY, bpp);
					return InitFail(hWnd, hRet, ch);
				}
			}
			
			ZeroMemory(&ddsd, sizeof(ddsd));
			ddsd.dwSize = sizeof(ddsd);
			ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
			ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
				DDSCAPS_FLIP |
				DDSCAPS_COMPLEX;
			ddsd.dwBackBufferCount = 1;
    
			if (g_pDD->CreateSurface(&ddsd, &Primary, NULL) != DD_OK)
				return InitFail(hWnd, hRet, "CreateSurface FAILED");

			// Get a pointer to the back buffer
			ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
			if (Primary->GetAttachedSurface(&ddscaps, &Back) != DD_OK)
				return InitFail(hWnd, hRet, "GetAttachedSurface FAILED");
			
			HDC hdc = GetDC(NULL);
    
			if (GetDeviceCaps(hdc, RASTERCAPS) & RC_PALETTE)
			{
				unsigned __int8 ir = 0, ig = 0, ib = 0,i = 0;
						
				while (ir < 8)
				{
					ig = 0;
					while (ig < 4)
					{
						ib = 0;
						while (ib < 8)
						{
							ape[i].peRed   = (256 / 8) * ir;
							ape[i].peGreen = (256 / 4) * ig;
							ape[i].peBlue  = (256 / 8) * ib;
							ib++;
							i++;
						};
					    ig++;
					};
					ir++;
				};
				if (g_pDD->CreatePalette(DDPCAPS_8BIT, ape, &Palette, NULL) == DD_OK)
					Primary->SetPalette(Palette);
        
			}
			ReleaseDC(NULL, hdc);

			pf.dwSize = sizeof(DDPIXELFORMAT);

			Primary->GetPixelFormat(&pf);

			rshift = GetNumberofBits(pf.dwRBitMask);
			gshift = GetNumberofBits(pf.dwGBitMask);
			bshift = GetNumberofBits(pf.dwBBitMask);

			ddsd.dwSize = sizeof(ddsd);
			return DD_OK;
		}

		int GetScreenX() { return ScreenX; }
		int GetScreenY() { return ScreenY; }

		int GetMaxClipX() { return MaxClipX; }
		int GetMinClipX() { return MinClipX; }

		int GetScreenSize() { return ScreenSize; }
		int GetXOrigin() { return xo; }
		int GetYOrigin() { return yo; }

		HWND GetWindowHandle() { return hWnd; }
		
		LPDIRECTDRAWSURFACE4 GetBackSurface() { return Back;}

		void SetRenderType(int value)
		{
			this->ZBuf	  = false;
			this->Gouraud = false;
			this->Texture = false;
			this->Fog	  = false;

			if (value & 1) 
			{
				this->ZBuf = true;
				InitZBuffer();
			}
			if (value & 2) this->Gouraud = true;
			if (value & 4) this->Texture = true;
			if (value & 8) this->Fog	 = true;
		}
		void SetFogColour(BYTE r, BYTE g, BYTE b)
		{
			Fogr = r;
			Fogg = g;
			Fogb = b;
		}
		void Render(TWorld *World)
		{
			if (this->Fog) ClearBackBuffer(OzRGB(Fogr,Fogg,Fogb));
			else ClearBackBuffer();

			if (this->ZBuf) ClearZBuffer();
			if (Back->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL) == DD_OK) // Lock the back buffer
			{
				
				int loop = 0, loop2 = 0, loop3 = 0, pxr = 0, pyr = 0, pzr = 0, prp = 0;
				int FaceNum;
				int ObjectNum = World->GetNumObjects();
				float xang, yang, zang, xang2, yang2, zang2;
				do {
					
					FaceNum = World->GetObject(loop)->GetFaceNum();
					loop2 = 0;
					do	{	
						loop3 = 0;
						
						pxr = World->GetObject(loop)->GetWorldX();
						pyr = World->GetObject(loop)->GetWorldY();
						pzr = World->GetObject(loop)->GetWorldZ();
							
						
						pxr = World->GetCamera()->GetXPosition() + pxr;
						pyr = World->GetCamera()->GetYPosition() + pyr;
						pzr = World->GetCamera()->GetZPosition() + pzr;
						
						{

							/*TMaths * tm;
							tm = new TMaths();
							
							float sxa = tm->Sine(World->GetCamera()->GetPitch());
							float cxa = tm->CoSine(World->GetCamera()->GetPitch());

							float sya = tm->Sine(World->GetCamera()->GetYaw());
							float cya = tm->CoSine(World->GetCamera()->GetYaw());

							delete tm;*/

							float pitch = World->GetCamera()->GetPitch();
							float yaw = World->GetCamera()->GetYaw();
							float roll = World->GetCamera()->GetRoll();
							
							xang = pitch;
							yang = yaw;
							zang = roll;
							
							xang2 = xang;
							yang2 = yang;
							zang2 = zang;
							
							prp = World->GetCamera()->GetRawFOV();
					
						}
						do {
								// Convert the 3d object to 2d.
								World->GetObject(loop)->GetFace(loop2)->GetEdge(loop3)->GetFromVertex()->Convertto2d(xang2,yang2,zang2, 0, prp, exaggerate, pxr, pyr, pzr, ZMin, ZRenderDepth);
								World->GetObject(loop)->GetFace(loop2)->GetEdge(loop3)->GetToVertex()->Convertto2d(xang2,yang2,zang2, 0, prp, exaggerate, pxr, pyr, pzr, ZMin, ZRenderDepth);
								loop3++;					
						} while (loop3 < 3);
						loop3 = 0;
						do {
								// Clear the Vertex Visited Flag.					
								World->GetObject(loop)->GetFace(loop2)->GetEdge(loop3)->GetFromVertex()->Calculations_Finished();
								World->GetObject(loop)->GetFace(loop2)->GetEdge(loop3)->GetToVertex()->Calculations_Finished();
								loop3++;			
						} while (loop3 < 3);
			
						// Use simple back face detection technique to save a bit of time. 

						if (World->GetObject(loop)->GetFace(loop2)->Visible(MinClipX, MaxClipX, MinClipY, MaxClipY, xo, yo)) 
						{
							// Depending on the currently selected conditions draw the polgons.
							/*OzTriangle8Z(ddsd.lpSurface,ddsd.lPitch,World->GetObject(loop)->GetFace(loop2));*/

							if (this->Gouraud) OzTriangle8ZG(ddsd.lpSurface,ddsd.lPitch,World->GetObject(loop)->GetFace(loop2));
							else if (this->Fog) OzTriangle8ZF(ddsd.lpSurface,ddsd.lPitch,World->GetObject(loop)->GetFace(loop2));
							else if (this->Texture) OzTriangle8ZT(ddsd.lpSurface,ddsd.lPitch,World->GetObject(loop)->GetFace(loop2));
							else {
								if (!this->ZBuf) OzTriangle8((BYTE*)ddsd.lpSurface,World->GetObject(loop)->GetFace(loop2));
								else OzTriangle8Z(ddsd.lpSurface,ddsd.lPitch,World->GetObject(loop)->GetFace(loop2));
							}
						}
						loop2++;

					} while (loop2 < FaceNum);
				
					loop++;

				} while (loop < ObjectNum);
			Back->Unlock(NULL); // Unlock the Back Buffer
			}
		}
		bool Flip(LPDIRECTDRAWSURFACE4 lpDDSurfaceTargetOverride, DWORD dwFlags)
		{
			HRESULT hRet;
			hRet = Primary->Flip(lpDDSurfaceTargetOverride, dwFlags);
            if (hRet == DD_OK)
				return true;
            if (hRet == DDERR_SURFACELOST)
			{
				hRet = Primary->Restore();
				if (hRet != DD_OK)
					return false;
			}
			if (hRet != DDERR_WASSTILLDRAWING)
				return false;
			return false;
		}
		HRESULT FlipGDI()
		{
			HRESULT hRet = g_pDD->FlipToGDISurface();
			if (hRet != DD_OK) return InitFail(hWnd, hRet, "FlipToGDISurface FAILED");
			return hRet;
			
		}
		HRESULT GetGDI()
		{
			HRESULT hRet = g_pDD->GetGDISurface(&Primary);
			if (hRet != DD_OK) return InitFail(hWnd, hRet, "GetGDISurface FAILED");
			else return hRet;
		}
		HRESULT Restore()
		{
			HRESULT hRet = g_pDD->RestoreAllSurfaces();
			if (hRet != DD_OK) return InitFail(hWnd, hRet, "RestoreAllSurfaces FAILED");
			else return hRet;
		}
		HRESULT RestoreDisplay()
		{
			HRESULT hRet = g_pDD->RestoreDisplayMode();
			if (hRet != DD_OK) return InitFail(hWnd, hRet, "RestoreDisplayMode FAILED");
			else return hRet;

		}


};